%% [Title of the paper]
%%  [Authors of the paper]
%%
%%  Copyright (C) 2015 Tanumoy Saha <tanumoy at uni-muenster.de> and Milos Galic  <galic at uni-muenster.de>
%%
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%
function varargout = maskAnalysis_test1(varargin)
% MASKANALYSIS_TEST1 MATLAB code for maskAnalysis_test1.fig
%      MASKANALYSIS_TEST1, by itself, creates a new MASKANALYSIS_TEST1 or raises the existing
%      singleton*.
%
%      H = MASKANALYSIS_TEST1 returns the handle to a new MASKANALYSIS_TEST1 or the handle to
%      the existing singleton*.
%
%      MASKANALYSIS_TEST1('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MASKANALYSIS_TEST1.M with the given input arguments.
%
%      MASKANALYSIS_TEST1('Property','Value',...) creates a new MASKANALYSIS_TEST1 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before maskAnalysis_test1_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to maskAnalysis_test1_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help maskAnalysis_test1

% Last Modified by GUIDE v2.5 03-May-2016 15:47:37

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @maskAnalysis_test1_OpeningFcn, ...
                   'gui_OutputFcn',  @maskAnalysis_test1_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before maskAnalysis_test1 is made visible.
function maskAnalysis_test1_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to maskAnalysis_test1 (see VARARGIN)

% Choose default command line output for maskAnalysis_test1
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes maskAnalysis_test1 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = maskAnalysis_test1_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


%% --- Executes on button press in mask_mat.
function mask_mat_Callback(hObject, eventdata, handles)
% hObject    handle to mask_mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Loading Combined Channel as cell body %%
fname= 'tmp_cell_stack.tif'; 
info = imfinfo(fname);
num_images = numel(info)

for k = 1:num_images 
    tmp_cell(:,:,k) = imread(fname,k);
end

%% Loading Variables for making the boundary binary image of the cell
edgefill = 1;
size_residues = 10;
threshold = .30;
%hf = findobj('Tag','axes3');
active_mask = tmp_cell;

h7 = findobj('Tag','frame_num');
k= round(get(h7,'value'));
set(h7, 'min', 1);
mx = size(active_mask,3);
set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', 1);

h8 = findobj('Tag','pxtomicro');
fileID = fopen('tmp.txt','r');
px_micro = fscanf(fileID,'%d')
set(h8,'userdata',px_micro);
fclose(fileID);

for t=1:size(active_mask,3)
    img = active_mask(:,:,t);
    
    bgd_color1 = median(img(:));
    img(img<= bgd_color1) = 0;
    img = edge(img,'Canny',threshold);
    for i =1:edgefill
        img = imclose(img,strel('disk', 4));
        img = imfill(img,'holes'); 
    end
    img = bwareaopen(img>0,size_residues);
    img = edge(img,'Canny',threshold);
    active_mask(:,:,t) =img;  
end
%% Playing the boundary cell stack file in axes1 and setting the slider properties
axes(handles.axes1);
colormap(jet);
set(hObject,'UserData',active_mask);
% set(handles.axes1,'xLim',[-size(img,2) 0])
for k = 1:size(active_mask,3)
    hold off;
    imagesc(active_mask(:,:,k));
%      set(handles.axes1,'xLabel',[-size(img,2) 0])
    pause(0.003)
    hold on;
%     axis([xmin,xmax,ymax,ymin])
end
h2 = findobj('Tag','ref_ori')
set( h2,'UserData',[0 0]); %%%%default

h3 = findobj('Tag','no_hinges');
set( h3,'string',num2str(1)); %%%%default

h4 = findobj('Tag','radius_mark');
set( h4,'string',num2str(5)); %%%%default
%% ----------------------------------------------------------------------------




%% --- Executes on button press in rubber_band.
function rubber_band_Callback(hObject, eventdata, handles)
% hObject    handle to rubber_band (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Displaying the ConvexHull image at the frame determined by the slider
h1 = findobj('Tag','mask_mat')
active_mask = get(h1,'UserData');
axes(handles.axes1);
colormap(jet)
for t = 1:size(active_mask,3)
    img = active_mask(:,:,t);
    [y,x] = find(flipud(img));
     k = convhull(y,x);
     imagesc(flipud(img));
     hold on;
     plot(x(k),y(k),'g-*','linewidth',1);
     set(gca,'ydir','normal');
     hold off
     pause(0.003)
end
%% ------------------------------------------------------------------------------



% --- Executes on button press in ref_ori.
function ref_ori_Callback(hObject, eventdata, handles)
% hObject    handle to ref_ori (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Selects the starting point of measurement followed by the vertice needed to track by an interactive tool
[x y] = ginput(2);
set( hObject,'UserData',[x y]);
data = get(hObject,'UserData')
line(x , y,'color','r');  %x-axis
%% -------------------------------------------------------------------------------------------------------




% --- Executes on button press in leadingEdgeAnalyze.
function leadingEdgeAnalyze_Callback(hObject, eventdata, handles)
% hObject    handle to leadingEdgeAnalyze (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%% Tracks the filopodia in each and everz frame and stores the tracking coordinates in memory for further analysis
clc
filename = 'dynamics.xlsx';
h1 = findobj('Tag','mask_mat');
h2 = findobj('Tag','ref_ori');
h3 = findobj('Tag','no_hinges');
h4 = findobj('Tag','radius_mark');
h5 = findobj('Tag','scan_length');
h6 = findobj('Tag','accu_active_length');
h14 = findobj('Tag','pxtomicro');
h8 = findobj('Tag','angle_thresh');

tmp_no_segment = round(str2double(get(h3,'string')));
radius = round(str2double(get(h4,'string')));
scanLength = round(str2double(get(h5,'string')));
thresh_accu = round(str2double(get(h6,'string')));
angle_threshold = round(str2double(get(h8,'string')));
active_mask = get(h1,'UserData');
cor0 = get(h2,'UserData');
h7 = findobj('Tag','frame_num');
k= round(get(h7,'value'));
set(h7, 'min', 1);
mx = size(active_mask,3);
set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', 1);
x0 = cor0(2,1);
y0 = cor0(2,2);
x0t = x0;
y0t = y0;

xo = cor0(1,1);
yo = cor0(1,2);
len = [];

h8 = findobj('Tag','pxtomicro');
px_micro = get(h8,'userdata');

str = '1';
h13 = findobj('Tag','dis_mlt_fac');
set(h13,'string',str);

for t = 1:size(active_mask,3)
    centers = [];
    set(h7, 'value', t);
    axes(handles.axes1);
    colormap(jet)
    img = active_mask(:,:,t);
    xd = [];
    yd = [];
    [y,x] = find(flipud(img));
    k = convhull(y,x);
    dissqr = zeros(length(k),1);
    imagesc(flipud(img));
    hold on;
    for i = 1: length(k)
        dissqr(i) = sqrt((x(k(i))-x0)^2+(y(k(i))-y0)^2) ;
    end
    [sorted, Ind] = sort(dissqr);
    frame(t) = t;
    
    xh = x(k(i));
    yh = y(k(i));
    theta_prev = atan2(y0t-yo,x0t-xo)/pi*180;
    if dissqr(Ind(1))<=radius
        xt = x0;
        x0 = x(k(Ind(1)));
        yt = y0;
        y0 = y(k(Ind(1)));
    end
    theta_curr = atan2(y0-yo,x0-xo)/pi*180;
    diff_theta = abs(theta_curr-theta_prev)
    if diff_theta>=angle_threshold
        x0 = xt;
        y0 = yt;
    end
    [corx , cory] = divide_line(tmp_no_segment,[xo yo],[x0 y0],1)

    centers(:,1) = corx';
    centers(:,2) = cory';
    [centers,len(t)] = update_centers(flipud(active_mask(:,:,t)),centers,radius,scanLength, thresh_accu);
    if (get(h8,'value')==get(h8,'max'))
        len(t) = px_micro*len(t);
    end
%     centers_primitive = centers;
    if t>1
        velfilo(t)=len(t)-len(t-1);
    else
        velfilo(t)= 0;
    end
    radius_circles = 2*ones(1,length(corx));
    radius_circles(1,length(corx)) = radius;
    viscircles(centers,radius_circles);
    hold on
    xd=centers(:,1); %[xo,x0];
    yd=centers(:,2);
    plot(xd,yd,'g--*','linewidth',2);
    hold on
    plot(x(k),y(k),'g-*','linewidth',1);
    set(gca,'ydir','normal');
    set(gca,'xdir','normal');
    colormap jet

    hold off
    if (t>3)
        axes(handles.axes2);
        colormap(jet);
        plot(frame(3:end),velfilo(3:end),'b-*','linewidth',2,'DisplayName','velocity of Leading edge');
        hold on
        plot(frame(3:end),len(3:end),'r-o','linewidth',2,'DisplayName','Approximated Length of filopodia');
        hold on

        xlabel({'frame number'})
        if get(h14,'value') == get(h14,'Max')
            ylabel({'Arbitrary measure in microns'});
        else
            ylabel({'Arbitrary measure in pixels'});
        end
        
        grid on;
        grid minor;
        set(gca,'gridlinestyle','-.');
        legend('show','Location','northwest');
        hold off;
    end
    cor(:,:,t) = centers;

    pause(0.003)
    cntr = [];
    cx= [];
    cy= [];
end
set(hObject,'UserData',cor);
frame_num = frame(3:end)
frame_num = frame_num'
size(frame_num)
length_of_filopodia = len(3:end);
length_of_filopodia =length_of_filopodia';
size(length_of_filopodia)
velocity_leading = velfilo(3:end);
velocity_leading = velocity_leading';
size(velocity_leading)
t = xlsread('dynamics.xlsx','Sheet1');
if ~isempty(t)
    xlswrite('dynamics.xlsx',zeros(size(t))*nan);
end
col_header={'frame number','length','velocity'};  
xlswrite(filename,frame_num,'Sheet1','A2');
xlswrite(filename,col_header,'Sheet1','A1');     
xlswrite(filename,length_of_filopodia,'Sheet1','B2');
xlswrite(filename,velocity_leading,'Sheet1','C2');
%% ----------------------------------------------------------------------------------------------------------------




% --- Executes on button press in mark.
function mark_Callback(hObject, eventdata, handles)
% hObject    handle to mark (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% h1  = findobj('Tag','no_hinges');
h3 = findobj('Tag','no_hinges');
tmp_val = get(h3,'Value')
set( h3,'Value',tmp_val);
%


function no_hinges_Callback(hObject, eventdata, handles)
% hObject    handle to no_hinges (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of no_hinges as text
%        str2double(get(hObject,'String')) returns contents of no_hinges as a double



% --- Executes during object creation, after setting all properties.
function no_hinges_CreateFcn(hObject, eventdata, handles)
% hObject    handle to no_hinges (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function radius_mark_Callback(hObject, eventdata, handles)
% hObject    handle to radius_mark (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of radius_mark as text
%        str2double(get(hObject,'String')) returns contents of radius_mark as a double


% --- Executes during object creation, after setting all properties.
function radius_mark_CreateFcn(hObject, eventdata, handles)
% hObject    handle to radius_mark (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function scan_length_Callback(hObject, eventdata, handles)
% hObject    handle to scan_length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of scan_length as text
%        str2double(get(hObject,'String')) returns contents of scan_length as a double


% --- Executes during object creation, after setting all properties.
function scan_length_CreateFcn(hObject, eventdata, handles)
% hObject    handle to scan_length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function accu_active_length_Callback(hObject, eventdata, handles)
% hObject    handle to accu_active_length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of accu_active_length as text
%        str2double(get(hObject,'String')) returns contents of accu_active_length as a double


% --- Executes during object creation, after setting all properties.
function accu_active_length_CreateFcn(hObject, eventdata, handles)
% hObject    handle to accu_active_length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in anal_protein.
function anal_protein_Callback(hObject, eventdata, handles)
% hObject    handle to anal_protein (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of anal_protein
clc
filename = 'dynamics.xlsx' ;

h1 = findobj('Tag','proteinA');
h2 = findobj('Tag','proteinB');
h3 = findobj('Tag','proteinC');
h4 = findobj('Tag','whle_filo');
h5 = findobj('Tag','leadingEdge');
h6 = findobj('Tag','leadingEdgeAnalyze');
h7 = findobj('Tag','scan_length');
h8 = findobj('Tag','tipLen');
h9 = findobj('Tag','threshhold');
h10 = findobj('Tag','plot_all');
h11 = findobj('Tag','ld_log_ba');
h12 = findobj('Tag','ld_log_ca');
h13 = findobj('Tag','dis_mlt_fac');
h14 = findobj('Tag','pxtomicro');
scanLength = round(str2double(get(h7,'string')));
tiplength = round(str2double(get(h8,'string')));
denwidth = round(str2double(get(h9,'string')));
cor = get(h6,'UserData');
n_tmp=0
str = '1'

if get(h14,'value') == get(h14,'Max')
     px_micro = get(h14,'userdata');
     str = num2str(px_micro);
     set(h13,'string',str);
else
    set(h13,'string',str);
end

if (get(h1,'Value') == get(h1,'Max'))
    fname_pro1= 'tmp_pro1_stack.tif'; 
    info_pro1 = imfinfo(fname_pro1);
    num_images_pro1 = numel(info_pro1);
	for k = 1:num_images_pro1
       tmp_pro1(:,:,k) = imread(fname_pro1,k);
    end
   
    %mat = zeros(1000,num_images_pro1);
    if (get(h4,'Value') == get(h4,'Max'))
        hold off
        axes(handles.axes2);
        
        for k = 3:num_images_pro1
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro1(:,:,k),xi,yi);
            n  = length(c);
           
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro1,n);
         for k = 3:num_images_pro1
             xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro1(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            ci = get_intensity(flipud(tmp_pro1(:,:,k)),cntr,scanLength)
%             hold off
           new_mat(k,1:length(ci))= ci;
           imagesc((new_mat'))
           set(handles.axes2,'YDir','normal')
           if get(h14,'value') == get(h14,'Max')
               ylabel({'Arbitrary measure in microns'});
           else
               ylabel({'Arbitrary measure in pixels'});
           end
            xlabel({'frame number'});
%             map
            %colormap jet
            colorbar
            pause(0.003)
            
            cntr = [];
         end
         t = xlsread('dynamics.xlsx','Sheet2');
         if ~isempty(t)
            xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet2','A1');
         end
    %     xlswrite(filename,new_mat,'Sheet2','A1');
        set(h1,'UserData',new_mat);
%         hf = axes(handles.axes2);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'pro1.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        minimum = min(new_mat(new_mat>0))
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        new_mat = log10(new_mat/max(new_mat(:))*9 +1);
        imagesc((new_mat'))
        set(handles.axes2,'YDir','normal')
        if get(h14,'value') == get(h14,'Max')
            ylabel({'Arbitrary measure in microns'});
        else
            ylabel({'Arbitrary measure in pixels'});
        end
        xlabel({'frame number'});
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'Normpro1.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        xlswrite(filename,new_mat,'Sheet2','A1');
        colorbar
        hold off
    end
%          hold off
    if (get(h5,'Value') == get(h5,'Max'))
        hold off
        axes(handles.axes2);
        for k = 3:num_images_pro1
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro1(:,:,k),xi,yi);
            n  = length(c);
           
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro1,n);
         lead_proA = zeros(num_images_pro1,1)*NaN;
         for k = 3:num_images_pro1
             xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro1(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            ci = get_intensity(flipud(tmp_pro1(:,:,k)),cntr,scanLength);
%             hold off
            new_mat(k,1:length(ci))= ci;
           if length(ci)>=denwidth
                lead_proA(k,1) = mean(ci(end-tiplength:end));
           end
%            imagesc(flipud(new_mat'))
%             map
            plot(lead_proA,'g-*','linewidth',1);
            pause(0.003)
            
            cntr = [];
        
         end
         minimum = min(new_mat(new_mat>0))
         
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        lead_proA = lead_proA-minimum
        lead_proA = log10(lead_proA/max(new_mat(:))*9 +1);
        plot(lead_proA,'g-*','linewidth',1)
        hold off;
    end 
    
    % xlswrite(filename,col_header,'Sheet2','A1');     %Write column header
%     xlswrite(filename,length_of_filopodia,'Sheet1','B2');
%     xlswrite(filename,velocity_leading,'Sheet1','C2');
end
    
if (get(h2,'Value') == get(h2,'Max'))
    fname_pro2= 'tmp_pro2_stack.tif'; 
    info_pro2 = imfinfo(fname_pro2);
    num_images_pro2 = numel(info_pro2);
    
    for k = 1:num_images_pro2
        tmp_pro2(:,:,k) = imread(fname_pro2,k);
    end 
   
    %mat = zeros(1000,num_images_pro1);
    if (get(h4,'Value') == get(h4,'Max'))
        hold off
        axes(handles.axes2);
        for k = 3:num_images_pro2
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro2(:,:,k),xi,yi);
            n  = length(c)
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro2,n);
         for k = 3:num_images_pro2
             xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro2(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            c = get_intensity(flipud(tmp_pro2(:,:,k)),cntr,scanLength)
%             hold off
           new_mat(k,1:length(c))= c;
           imagesc((new_mat'))
           set(handles.axes2,'YDir','normal')
           if get(h14,'value') == get(h14,'Max')
               ylabel({'Arbitrary measure in microns'});
           else
               ylabel({'Arbitrary measure in pixels'});
           end
            xlabel({'frame number'});
            %colormap jet
            colorbar
            pause(0.003)
            cntr = [];
         end
%          hold off
        t = xlsread('dynamics.xlsx','Sheet3');
        if ~isempty(t)
        xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet3','A1');
        end
    %     xlswrite(filename,new_mat,'Sheet3','A1');
        set(h2,'UserData',new_mat);


        minimum = min(new_mat(new_mat>0))
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'pro2.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        new_mat = log10(new_mat/max(new_mat(:))*9 +1);
        imagesc((new_mat'))
        set(handles.axes2,'YDir','normal')
        if get(h14,'value') == get(h14,'Max')
            ylabel({'Arbitrary measure in microns'});
        else
            ylabel({'Arbitrary measure in pixels'});
        end
         xlabel({'frame number'});
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'Normpro2.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        xlswrite(filename,new_mat,'Sheet3','A1');
        colorbar
        hold off
    end
    
    if (get(h5,'Value') == get(h5,'Max'))
        hold off
        axes(handles.axes2);
        for k = 3:num_images_pro2
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro2(:,:,k),xi,yi);
            n  = length(c);
           
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro2,n);
         lead_proB = zeros(num_images_pro2,1)*NaN;
         for k = 3:num_images_pro2
             xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro2(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            ci = get_intensity(flipud(tmp_pro2(:,:,k)),cntr,scanLength)
%             hold off
           new_mat(k,1:length(ci))= ci;
           if length(ci)>=denwidth
                lead_proB(k,1) = mean(ci(end-tiplength:end));
           end
%            imagesc(flipud(new_mat'))
%             map
            plot(lead_proB,'r-o','linewidth',1);
            pause(0.003)
            
            cntr = [];
        
         end
        minimum = min(new_mat(new_mat>0))
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        lead_proB = lead_proB-minimum
        lead_proB = log10(lead_proB/max(new_mat(:))*9 +1);
        plot(lead_proB,'r-o','linewidth',1)
        norm_ratio_ba = lead_proB - lead_proA ;
        set(h11,'userdata',norm_ratio_ba);

        hold off;
    end 
    
end

if (get(h3,'Value') == get(h3,'Max'))
    fname_pro3= 'tmp_pro3_stack.tif'; 
    info_pro3= imfinfo(fname_pro3);
    num_images_pro3 = numel(info_pro3);

     for k = 1:num_images_pro3
        tmp_pro3(:,:,k) = imread(fname_pro3,k);
     end
    
    
    if (get(h4,'Value') == get(h4,'Max'))
        hold off
        axes(handles.axes2);
        for k = 3:num_images_pro3
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro3(:,:,k),xi,yi);
            n  = length(c);           
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro3,n);
         for k = 3:num_images_pro3
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro3(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            c = get_intensity(flipud(tmp_pro3(:,:,k)),cntr,scanLength)
%             hold off
           new_mat(k,1:length(c))= c;
           imagesc((new_mat'))
           set(handles.axes2,'YDir','normal')
           if get(h14,'value') == get(h14,'Max')
               ylabel({'Arbitrary measure in microns'});
           else
               ylabel({'Arbitrary measure in pixels'});
           end
            xlabel({'frame number'});
            %colormap jet
            colorbar 
            pause(0.003)
            cntr = [];
         end
%          hold off
        t = xlsread('dynamics.xlsx','Sheet4');
        if ~isempty(t)
        xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet4','A1');
        end
    %     xlswrite(filename,new_mat,'Sheet4','A1');
        set(h3,'UserData',new_mat);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'pro3.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


    %     xlswrite(filename,new_mat,'Sheet4','A1');
        minimum = min(new_mat(new_mat>0))
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        new_mat = log10(new_mat/max(new_mat(:))*9 +1);
        imagesc((new_mat'))
        set(handles.axes2,'YDir','normal')
        if get(h14,'value') == get(h14,'Max')
            ylabel({'Arbitrary measure in microns'});
        else
            ylabel({'Arbitrary measure in pixels'});
        end
         xlabel({'frame number'});
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'Normpro3.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        xlswrite(filename,new_mat,'Sheet4','A1');
        colorbar
        hold off
    end 
    if (get(h5,'Value') == get(h5,'Max'))
        hold off
        axes(handles.axes2);
        for k = 3:num_images_pro3
            xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro3(:,:,k),xi,yi);
            n  = length(c);
           
            if n_tmp>n
                n = n_tmp;
            end 
             n_tmp = n;
         end
         %mat = zeros(n);
         new_mat = zeros(num_images_pro3,n);
         lead_proC = zeros(num_images_pro3,1)*NaN;
         for k = 3:num_images_pro3
             xi = cor(:,1,k);
            yi = cor(:,2,k);
            [cx,cy,c] = improfile(tmp_pro3(:,:,k),xi,yi);
            cntr(:,1) = cx;
            cntr(:,2) = cy;
            
%             axes(handles.axes1);
%             length(c)
            ci = get_intensity(flipud(tmp_pro3(:,:,k)),cntr,scanLength)
%             hold off
           new_mat(k,1:length(ci))= ci;
           if length(ci)>=denwidth
                lead_proC(k,1) = mean(ci(end-tiplength:end));
           end
%            imagesc(flipud(new_mat'))
%             map
            plot(lead_proC,'b-+','linewidth',1);
            pause(0.003)
            
            cntr = [];
        
         end
        minimum = min(new_mat(new_mat>0))
        new_mat = new_mat -minimum;
        new_mat(new_mat<0) = 0;
        lead_proC = lead_proC-minimum
        lead_proC = log10(lead_proC/max(new_mat(:))*9 +1);
        plot(lead_proC,'b-+','linewidth',1)
        norm_ratio_ca = lead_proC - lead_proA ;
        set(h12,'userdata',norm_ratio_ca);
        hold off;
    end 
%     new_mat = new_mat(new_mat>0) ;
    
end
t = xlsread('dynamics.xlsx','Sheet7');
if ~isempty(t)
xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet7','A1');
end



if (get(h10,'Value') == get(h10,'Max') && get(h5,'Value') == get(h5,'Max'))
    
    axes(handles.axes2);
    if (get(h1,'Value') == get(h1,'Max'))
        plot(lead_proA','g-*','linewidth',2)
        hold on
        xlswrite(filename,lead_proA,'Sheet7','A1');
%         legend('show','Location','northwest');
    end
    if (get(h2,'Value') == get(h2,'Max'))
        plot(lead_proB','r-o','linewidth',2)
        hold on
        xlswrite(filename,lead_proB,'Sheet7','B1');
%         legend('show','Location','northwest');
    end
    if (get(h3,'Value') == get(h3,'Max'))
        plot(lead_proC','b-+','linewidth',2)
        hold on
        xlswrite(filename,lead_proC,'Sheet7','C1');
        
    end
    legend('show','Location','northwest');
    hold off
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'LeadTip.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
end







        
        







% --- Executes on button press in proteinA.
function proteinA_Callback(hObject, eventdata, handles)
% hObject    handle to proteinA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of proteinA


% --- Executes on button press in proteinB.
function proteinB_Callback(hObject, eventdata, handles)
% hObject    handle to proteinB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of proteinB


% --- Executes on button press in proteinC.
function proteinC_Callback(hObject, eventdata, handles)
% hObject    handle to proteinC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of proteinC


% --- Executes on button press in whle_filo.
function whle_filo_Callback(hObject, eventdata, handles)
% hObject    handle to whle_filo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of whle_filo


% --- Executes on button press in leadingEdge.
function leadingEdge_Callback(hObject, eventdata, handles)
% hObject    handle to leadingEdge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of leadingEdge


% --- Executes on button press in cross_corr_init.
function cross_corr_init_Callback(hObject, eventdata, handles)
% hObject    handle to cross_corr_init (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in togglebutton1.
function togglebutton1_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of togglebutton1


% --- Executes on button press in log_ba.
function log_ba_Callback(hObject, eventdata, handles)
% hObject    handle to log_ba (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of log_ba


% --- Executes on button press in log_ca.
function log_ca_Callback(hObject, eventdata, handles)
% hObject    handle to log_ca (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of log_ca


% --- Executes on button press in compare.
function compare_Callback(hObject, eventdata, handles)
% hObject    handle to compare (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h1 = findobj('Tag','proteinA');
h2 = findobj('Tag','proteinB');
h3 = findobj('Tag','proteinC');
h4 = findobj('Tag','log_ba');
h5 = findobj('Tag','log_ca');
h7 = findobj('Tag','ld_log_ba');
h8 = findobj('Tag','ld_log_ca');
new_mat_pro1 = get(h1,'UserData');

minimum = min(new_mat_pro1(new_mat_pro1>0));
new_mat_pro1 = new_mat_pro1 -minimum;
new_mat_pro1(new_mat_pro1<0) = 0;
new_mat_pro1 = log10(new_mat_pro1/max(new_mat_pro1(:))*9 +1);
red = (0:1/250:1);
blue = 1-red;
green = 2*[red(1:end/2),blue(end/2:end)];

tmp = green;
green = blue;
blue = tmp;

map_mod = [red',green',blue']
map_mod(round(size(map_mod,1)/2),:)=[0 0 0];
if get(h2,'value') == get(h2,'max')
    if get(h4,'value') == get(h4,'max')
        new_mat_pro2 = get(h2,'UserData');
        minimum = min(new_mat_pro2(new_mat_pro2>0));
        new_mat_pro2 = new_mat_pro2 -minimum;
        new_mat_pro2(new_mat_pro2<0) = 0;
        new_mat_pro2 = log10(new_mat_pro2/max(new_mat_pro2(:))*9 +1);
        
        comp_ba = new_mat_pro2-new_mat_pro1;
        axes(handles.axes2);
        
        
        %colormap(jet);
        map = colormap;
%         map(round(size(map,1)/2),:)=[0 0 0];
%         map(round(size(map,1)/2)+1,:)=[0 0 0];
        colormap(map);
%         colormap(map_mod);
        imagesc(flipud(comp_ba'))
        colorbar
        [cmin,cmax] = caxis;
        caxis([-cmax,cmax])
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'NormB_by_A.png');
        hold off
        t = xlsread('dynamics.xlsx','Sheet5');
        if ~isempty(t)
        xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet5','A1');
        end
        xlswrite('dynamics.xlsx',comp_ba,'Sheet5','A1');
        
        
    end
    if get(h7,'value') == get(h7,'max')
        norm_ratioba = get(h7,'userdata');
        plot(norm_ratioba','b-+','linewidth',2)
        xlswrite('dynamics.xlsx',norm_ratioba,'Sheet7','D1');
        hold off
    end
    
    
end

if get(h3,'value') == get(h3,'max')
    if get(h5,'value') == get(h5,'max')
        new_mat_pro3 = get(h3,'UserData')
        minimum = min(new_mat_pro3(new_mat_pro3>0));
        new_mat_pro3 = new_mat_pro3 -minimum;
        new_mat_pro3(new_mat_pro3<0) = 0;
        new_mat_pro3 = log10(new_mat_pro3/max(new_mat_pro3(:))*9 +1);
        
        comp_ca = new_mat_pro3-new_mat_pro1
        axes(handles.axes2);
        map = colormap;
%         map(round(size(map,1)/2),:)=[0 0 0];
%         map(round(size(map,1)/2)+1,:)=[0 0 0];
        colormap(map);
        imagesc(flipud(comp_ca'))
        colorbar
        [cmin,cmax] = caxis;
        caxis([-cmax,cmax])
%         imagesc(flipud(comp_ca'))
%         colorbar
%         [cmin,cmax] = caxis;
%         caxis([-cmax,cmax])
%         map = colormap;
%         map(end/2,:)=[0 0 0];
%          map(end/2+1,:)=[0 0 0];
%         colormap(map);
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        dataFrame = getframe(handles.axes2);
        [im,imMap] = frame2im(dataFrame);
        imwrite(im,'NormC_by_A.png');
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        hold off
        t = xlsread('dynamics.xlsx','Sheet6');
        if ~isempty(t)
        xlswrite('dynamics.xlsx',zeros(size(t))*nan,'Sheet6','A1');
        end
        xlswrite('dynamics.xlsx',comp_ca,'Sheet6','A1');
        
    end
    if get(h8,'value') == get(h8,'max')
        norm_ratioca = get(h8,'userdata');
        plot(norm_ratioca','r-+','linewidth',2)
        xlswrite('dynamics.xlsx',norm_ratioca,'Sheet7','E1');
        hold off
    end
    
    
end


        
        


% --- Executes on slider movement.
function frame_num_Callback(hObject, eventdata, handles)
% hObject    handle to frame_num (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
h1 = findobj('Tag','mask_mat');
h2 = findobj('Tag','ref_ori');
h3 = findobj('Tag','no_hinges');
h4 = findobj('Tag','radius_mark');
h5 = findobj('Tag','scan_length');
h6 = findobj('Tag','accu_active_length');
h7 = findobj('Tag','leadingEdgeAnalyze');
h8 = findobj('Tag','his_trace');
t = round(get(hObject,'Value'))
active_mask = get(h1,'UserData');
axes(handles.axes1);
img = active_mask(:,:,t);
cor = get(h6,'UserData');
% [y,x] = find((img));
% k = convhull(y,x)
% imagesc((img));
% hold on;
% plot(x(k),y(k),'g-*','linewidth',1);
% hold off;

[y,x] = find(flipud(img));
 k = convhull(y,x);
 imagesc(flipud(img));
 % NOTE: if your image is RGB, you should use flipdim(img, 1) instead of flipud.
 hold on;
 plot(x(k),y(k),'g-*','linewidth',1);
 hold on
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 if get(h8,'value')== 1
    centers = cor(:,:,t)
    radius_circles = 2*ones(1,length(corx)
    radius_circles(1,size(centers,2)) = radius
%     viscircles(centers,radius_circles);
 end

 % set the y-axis back to normal.
 set(gca,'ydir','normal');
 hold off






% --- Executes during object creation, after setting all properties.
function frame_num_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frame_num (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in leadingEdgeAnalyze.

% hObject    handle to leadingEdgeAnalyze (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function tipLen_Callback(hObject, eventdata, handles)
% hObject    handle to tipLen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tipLen as text
%        str2double(get(hObject,'String')) returns contents of tipLen as a double


% --- Executes during object creation, after setting all properties.
function tipLen_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tipLen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function threshhold_Callback(hObject, eventdata, handles)
% hObject    handle to threshhold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of threshhold as text
%        str2double(get(hObject,'String')) returns contents of threshhold as a double


% --- Executes during object creation, after setting all properties.
function threshhold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to threshhold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in plot_all.
function plot_all_Callback(hObject, eventdata, handles)
% hObject    handle to plot_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of plot_all


% --- Executes on button press in edit_colormap.
function edit_colormap_Callback(hObject, eventdata, handles)
% hObject    handle to edit_colormap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
colormapeditor


% --- Executes on button press in reset_color.
function reset_color_Callback(hObject, eventdata, handles)
% hObject    handle to reset_color (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
colormap(jet)


% --- Executes on button press in ld_log_ba.
function ld_log_ba_Callback(hObject, eventdata, handles)
% hObject    handle to ld_log_ba (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ld_log_ba


% --- Executes on button press in ld_log_ca.
function ld_log_ca_Callback(hObject, eventdata, handles)
% hObject    handle to ld_log_ca (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ld_log_ca


% --- Executes on button press in pxtomicro.
function pxtomicro_Callback(hObject, eventdata, handles)
% hObject    handle to pxtomicro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of pxtomicro
% data = fscanf('tmp.txt','%d');
% set(hObject,'userdata',data);



function angle_thresh_Callback(hObject, eventdata, handles)
% hObject    handle to angle_thresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of angle_thresh as text
%        str2double(get(hObject,'String')) returns contents of angle_thresh as a double


% --- Executes during object creation, after setting all properties.
function angle_thresh_CreateFcn(hObject, eventdata, handles)
% hObject    handle to angle_thresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton14.
function pushbutton14_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in his_trace.
function his_trace_Callback(hObject, eventdata, handles)
% hObject    handle to his_trace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of his_trace
