function [intensity] = get_intensity(mask,centers,scan_width)
no_points = length(centers(:,1));
% xo = centers(1,1); 
% yo = centers(1,2); 
% x0 = centers(no_points,1);
% y0 = centers(no_points,2);
% distance = sqrt((x0-xo)^2+(y0-yo)^2);
% slope_ori = (y0-yo)/(x0-xo);
% slope_perpen = -1/slope_ori;
%scan_area = zeros(size(mask));
%tmp_mat = [1:size(mask,1)*size(mask,2)];
% np = 2;

% cos_theta = sqrt(1/(1+slope_ori^2));
% sin_theta = sqrt(1/(1+slope_ori^2))*slope_ori;

for i = 1:no_points-1
    xo = centers(i,1); 
    yo = centers(i,2); 
    x0 = centers(i+1,1);
    y0 = centers(i+1,2);
%     distance = sqrt((x0-xo)^2+(y0-yo)^2);
    slope_ori = (y0-yo)/(x0-xo);
    slope_perpen = -1/slope_ori;
    xn = centers(i,1);
    yn = centers(i,2); 
    cos_theta = sqrt(1/(1+slope_perpen^2));
    sin_theta = sqrt(1/(1+slope_perpen^2))*slope_perpen;
    if abs(slope_perpen) == Inf 
        cos_theta = 0;
        sin_theta = 1;
    end
    
    xi =round([xn-scan_width*cos_theta xn+scan_width*cos_theta]);
    yi =round([yn-scan_width*sin_theta yn+scan_width*sin_theta]);
%     plot(xi,yi,'c-o','linewidth',1)
%     hold on
    [cx,cy,c] = improfile(mask,xi,yi);
    c = sort(c,'descend')
    if length(c)>=5
        intensity(i)=mean(c(1:3));
    else
        intensity(i)=mean(c);
    end
    
end
hold off
pause(0.003)


length_line = 0;
for i = 1:length(centers(:,1))-1
    length_line = length_line + sqrt((centers(i+1,1)-centers(i,1))^2+(centers(i+1,2)-centers(i,2))^2);
end
end