%% [Title of the paper]
%%  [Authors of the paper]
%%
%%  Copyright (C) 2015 Tanumoy Saha <tanumoy at uni-muenster.de> and Milos Galic  <galic at uni-muenster.de>
%%
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%
function varargout = filoAnalysisM3(varargin)
% FILOANALYSISM3 MATLAB code for filoAnalysisM3.fig
%      FILOANALYSISM3, by itself, creates a new FILOANALYSISM3 or raises the existing
%      singleton*.
%
%      H = FILOANALYSISM3 returns the handle to a new FILOANALYSISM3 or the handle to
%      the existing singleton*.
%
%      FILOANALYSISM3('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FILOANALYSISM3.M with the given input arguments.
%
%      FILOANALYSISM3('Property','Value',...) creates a new FILOANALYSISM3 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before filoAnalysisM3_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to filoAnalysisM3_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help filoAnalysisM3

% Last Modified by GUIDE v2.5 14-Nov-2015 08:00:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @filoAnalysisM3_OpeningFcn, ...
                   'gui_OutputFcn',  @filoAnalysisM3_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before filoAnalysisM3 is made visible.
function filoAnalysisM3_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to filoAnalysisM3 (see VARARGIN)

% Choose default command line output for filoAnalysisM3
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes filoAnalysisM3 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = filoAnalysisM3_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in cell_channel.
function cell_channel_Callback(hObject, eventdata, handles)
% hObject    handle to cell_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h0 = findobj('Tag','msk_frm_chan');
if get(h0,'value')== get(h0,'max')
    data = initialize_read(0,'Select Stacked frames of cell body');
else
    hc1 = findobj('Tag','conf_pro1');
    hp1 = findobj('Tag','pro1_channel');
    if get(hc1,'value')== get(hc1,'max')
        data1 = get(hp1,'userdata');
    end
    
    hc2 = findobj('Tag','conf_pro2');
    hp2 = findobj('Tag','pro2_channel');
    if get(hc2,'value')== get(hc2,'max')
        data2 = get(hp2,'userdata');
        data = max(data1,data2) ;
%         data = reshape(data,size(data));
    end
    
    hc3 = findobj('Tag','conf_pro3');
    hp3 = findobj('Tag','pro3_channel');
    if get(hc3,'value')== get(hc3,'max')
        data3 = get(hp3,'userdata');
        data = max(data,data3) ;
%         data = reshape(data,size(data));
    end
    
end
% for i = 1: size(data,3)
%     img = data(:,:,i);
%     data(:,:,i) = imadjust(mat2gray(img));
% end
set(hObject, 'UserData',data);
% hObject.UserData = 1;
h1 = findobj('Tag','cell_mat');
set(h1,'UserData',data);

h2 = findobj('Tag','frame_no_cell');
k= round(get(h2,'value'));
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));

axes(handles.dis_cell);
imshow(data(:,:,1));
hold off

h5 = findobj('Tag','frame_no_cell');
h6 = findobj('Tag','start_frame');
h7 = findobj('Tag','end_frame');
%playframes1(data,0.003);
set(h5, 'min', 1);
mx = size(data,3);
% set(h5,'SliderStep',[1,0]);
set(h5, 'max', mx);
set(h5, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h6, 'min', 1);
% mx = size(tmp_cell,3);
% set(h6,'SliderStep',[1,0]);
set(h6, 'max', mx);
set(h6, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h7, 'min', 1);
% mx = size(tmp_cell,3);
% set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', mx);
outputFileName_cell = 'tmp_cell_stack.tif';

tmp_cell = data;
for k = 1:size(tmp_cell,3)
    
%     axes(handles.dis_cell);
%     imshow(tmp_cell(:,:,k));
%     hold off
%     axes(handles.dis_pro1);
%     imshow(tmp_pro1(:,:,k));
%     hold off
%     axes(handles.dis_pro2);
%     imshow(tmp_pro2(:,:,k));
%     hold off
%     axes(handles.dis_pro3);
%     imshow(tmp_pro3(:,:,k));
%     hold off
%     pause(0.003)
    if k == 1
        imwrite(tmp_cell(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
        
    end
    
end


% --- Executes on button press in pro1_channel.
function pro1_channel_Callback(hObject, eventdata, handles)
% hObject    handle to pro1_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hc = findobj('Tag','conf_pro1');
val = get(hc,'value');

if val == 1
    data = initialize_read(0,'Select Stacked frames of cell body');
    % for i = 1: size(data,3)
    %     img = data(:,:,i);
    %     data(:,:,i) = imadjust(mat2gray(img));
    % end
    set(hObject, 'UserData',data);
    % hObject.UserData = 1;
    h1 = findobj('Tag','pro1_mat');
    set(h1,'UserData',data);

%     h2 = findobj('Tag','frame_no_cell');
%     k= round(get(h2,'value'));
%     % ki= round(get(h1,'value'));
% 
%     h2 = findobj('Tag','start_frame');
%     ki= round(get(h2,'value'));
% 
%     h3 = findobj('Tag','end_frame');
%     ke= round(get(h3,'value'));
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    h5 = findobj('Tag','frame_no_cell');
    h6 = findobj('Tag','start_frame');
    h7 = findobj('Tag','end_frame');
    %playframes1(data,0.003);
    set(h5, 'min', 1);
    mx = size(data,3);
    set(h5,'SliderStep',[1,0]);
    set(h5, 'max', mx);
    set(h5, 'value', 1); % Somewhere between max and min.
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    set(h6, 'min', 1);
    % mx = size(tmp_cell,3);
    set(h6,'SliderStep',[1,0]);
    set(h6, 'max', mx);
    set(h6, 'value', 1); % Somewhere between max and min.
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    set(h7, 'min', 1);
    % mx = size(tmp_cell,3);
    set(h7,'SliderStep',[1,0]);
    set(h7, 'max', mx);
    set(h7, 'value', mx);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    k= round(get(h5,'value'));
    axes(handles.dis_pro1);
    imshow(data(:,:,k));
    hold off

    tmp_pro1 = data;
    outputFileName_cell = 'tmp_pro1_stack.tif';
    for k = 1:size(tmp_pro1,3)

    %     axes(handles.dis_cell);
    %     imshow(tmp_cell(:,:,k));
    %     hold off
    %     axes(handles.dis_pro1);
    %     imshow(tmp_pro1(:,:,k));
    %     hold off
    %     axes(handles.dis_pro2);
    %     imshow(tmp_pro2(:,:,k));
    %     hold off
    %     axes(handles.dis_pro3);
    %     imshow(tmp_pro3(:,:,k));
    %     hold off
    %     pause(0.003)
        if k == 1
            imwrite(tmp_pro1(:, :, k), outputFileName_cell);

        else
            imwrite(tmp_pro1(:, :, k), outputFileName_cell, 'WriteMode', 'append');

        end

    end
  end


% --- Executes on button press in pro2_channel.
function pro2_channel_Callback(hObject, eventdata, handles)
% hObject    handle to pro2_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hc = findobj('Tag','conf_pro2');
val = get(hc,'value');

if val == 1
    data = initialize_read(0,'Select Stacked frames of cell body');
    % for i = 1: size(data,3)
    %     img = data(:,:,i);
    %     data(:,:,i) = imadjust(mat2gray(img));
    % end
    set(hObject, 'UserData',data);
    % hObject.UserData = 1;
    h1 = findobj('Tag','pro2_mat');
    set(h1,'UserData',data);

    h2 = findobj('Tag','frame_no_cell');
    k= round(get(h2,'value'));
    % ki= round(get(h1,'value'));

    h2 = findobj('Tag','start_frame');
    ki= round(get(h2,'value'));

    h3 = findobj('Tag','end_frame');
    ke= round(get(h3,'value'));

    axes(handles.dis_pro2);
    imshow(data(:,:,k));
    hold off

    tmp_pro2 = data;
    outputFileName_cell = 'tmp_pro2_stack.tif';
    for k = 1:size(tmp_pro2,3)

    %     axes(handles.dis_cell);
    %     imshow(tmp_cell(:,:,k));
    %     hold off
    %     axes(handles.dis_pro1);
    %     imshow(tmp_pro1(:,:,k));
    %     hold off
    %     axes(handles.dis_pro2);
    %     imshow(tmp_pro2(:,:,k));
    %     hold off
    %     axes(handles.dis_pro3);
    %     imshow(tmp_pro3(:,:,k));
    %     hold off
    %     pause(0.003)
        if k == 1
            imwrite(tmp_pro2(:, :, k), outputFileName_cell);

        else
            imwrite(tmp_pro2(:, :, k), outputFileName_cell, 'WriteMode', 'append');

        end

    end
end


% --- Executes on button press in pro3_channel.
function pro3_channel_Callback(hObject, eventdata, handles)
% hObject    handle to pro3_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hc = findobj('Tag','conf_pro3');
val = get(hc,'value');

if val == 1
    data = initialize_read(0,'Select Stacked frames of cell body');
    % for i = 1: size(data,3)
    %     img = data(:,:,i);
    %     data(:,:,i) = imadjust(mat2gray(img));
    % end
    set(hObject, 'UserData',data);
    % hObject.UserData = 1;
    h1 = findobj('Tag','pro3_mat');
    set(h1,'UserData',data);

    h1 = findobj('Tag','frame_no_cell');
    k= round(get(h1,'value'));
    % ki= round(get(h1,'value'));

    h2 = findobj('Tag','start_frame');
    ki= round(get(h2,'value'));

    h3 = findobj('Tag','end_frame');
    ke= round(get(h3,'value'));

    axes(handles.dis_pro3);
    imshow(data(:,:,k));
    hold off

    tmp_pro3 = data;
    outputFileName_cell = 'tmp_pro3_stack.tif';
    for k = 1:size(tmp_pro3,3)

    %     axes(handles.dis_cell);
    %     imshow(tmp_cell(:,:,k));
    %     hold off
    %     axes(handles.dis_pro1);
    %     imshow(tmp_pro1(:,:,k));
    %     hold off
    %     axes(handles.dis_pro2);
    %     imshow(tmp_pro2(:,:,k));
    %     hold off
    %     axes(handles.dis_pro3);
    %     imshow(tmp_pro3(:,:,k));
    %     hold off
    %     pause(0.003)
        if k == 1
            imwrite(tmp_pro3(:, :, k), outputFileName_cell);

        else
            imwrite(tmp_pro3(:, :, k), outputFileName_cell, 'WriteMode', 'append');

        end

    end
end




% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1


% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in crop_all.
function crop_all_Callback(hObject, eventdata, handles)
% hObject    handle to crop_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc
axes(handles.dis_cell);
rect = getrect;
reg_edge = {[rect(2),rect(2)+rect(4)],[rect(1),rect(1)+rect(3)]};
set(hObject, 'UserData',reg_edge);
% tmp_cell = initialize_read(reg_edge,'Select Stacked frames of cell body');
tmp_cell = initialize_read_mk2('tmp_cell_stack.tif',reg_edge);

h1 = findobj('Tag','cell_mat');
h5 = findobj('Tag', 'crp_frm');
value = get(h5,'value');
set(h1, 'UserData',tmp_cell);
hold on
rectangle('Position',rect,'EdgeColor','w');
hold off;

h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');


% tmp_pro1 = initialize_read(reg_edge,'Select Stacked frames of protein 1');
if val1 == 1
    tmp_pro1 = initialize_read_mk2('tmp_pro1_stack.tif',reg_edge);
    h2 = findobj('Tag','pro1_mat');
    set(h2, 'UserData',tmp_pro1);
    axes(handles.dis_pro1);
    rectangle('Position',rect,'EdgeColor','r');
    hold off;
end

if val2 == 1
    % tmp_pro2 = initialize_read(reg_edge,'Select Stacked frames of protein 2');
    tmp_pro2 = initialize_read_mk2('tmp_pro2_stack.tif',reg_edge);
    h3 = findobj('Tag','pro2_mat');
    set(h3, 'UserData',tmp_pro2);
    axes(handles.dis_pro2);
    rectangle('Position',rect,'EdgeColor','g');
    hold off;
end

if val3 == 1
    % tmp_pro3 = initialize_read(reg_edge,'Select Stacked frames of protein 3');
    tmp_pro3 = initialize_read_mk2('tmp_pro3_stack.tif',reg_edge);
    h4 = findobj('Tag','pro3_mat');
    set(h4, 'UserData',tmp_pro3);
    axes(handles.dis_pro3);
    rectangle('Position',rect,'EdgeColor','b');
    hold off;
end

outputFileName_cell = 'tmp_cell_stack.tif';
outputFileName_pro1 = 'tmp_pro1_stack.tif';
outputFileName_pro2 = 'tmp_pro2_stack.tif';
outputFileName_pro3 = 'tmp_pro3_stack.tif';

for k = 1:size(tmp_cell,3)
    
%     axes(handles.dis_cell);
%     imshow(tmp_cell(:,:,k));
%     hold off
%     axes(handles.dis_pro1);
%     imshow(tmp_pro1(:,:,k));
%     hold off
%     axes(handles.dis_pro2);
%     imshow(tmp_pro2(:,:,k));
%     hold off
%     axes(handles.dis_pro3);
%     imshow(tmp_pro3(:,:,k));
%     hold off
%     pause(0.003)
    if k == 1
        
        imwrite(tmp_cell(:, :, k), outputFileName_cell);
        if val1 == 1
            imwrite(tmp_pro1(:, :, k), outputFileName_pro1);
        end
        if val2 == 1
            imwrite(tmp_pro2(:, :, k), outputFileName_pro2);
        end
        if val3 == 1
            imwrite(tmp_pro3(:, :, k), outputFileName_pro3);
        end
    else
        imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
        if val1 == 1
            imwrite(tmp_pro1(:, :, k), outputFileName_pro1, 'WriteMode', 'append');
        end
        if val2 == 1
            imwrite(tmp_pro2(:, :, k), outputFileName_pro2, 'WriteMode', 'append');
        end
        if val3 == 1
            imwrite(tmp_pro3(:, :, k), outputFileName_pro3, 'WriteMode', 'append');
        end
    end
    
end





% --- Executes on slider movement.
function contraHighPro3_Callback(hObject, eventdata, handles)
% hObject    handle to contraHighPro3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraHighPro3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraHighPro3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraLowPro3_Callback(hObject, eventdata, handles)
% hObject    handle to contraLowPro3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraLowPro3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraLowPro3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraLowPro2_Callback(hObject, eventdata, handles)
% hObject    handle to contraLowPro2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraLowPro2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraLowPro2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraHighPro2_Callback(hObject, eventdata, handles)
% hObject    handle to contraHighPro2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraHighPro2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraHighPro2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraHighPro1_Callback(hObject, eventdata, handles)
% hObject    handle to contraHighPro1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraHighPro1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraHighPro1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraLowPro1_Callback(hObject, eventdata, handles)
% hObject    handle to contraLowPro1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraLowPro1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraLowPro1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraLowCell_Callback(hObject, eventdata, handles)
% hObject    handle to contraLowCell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraLowCell_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraLowCell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function contraHighCell_Callback(hObject, eventdata, handles)
% hObject    handle to contraHighCell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function contraHighCell_CreateFcn(hObject, eventdata, handles)
% hObject    handle to contraHighCell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in play_cropped_all.
function play_cropped_all_Callback(hObject, eventdata, handles)
% hObject    handle to play_cropped_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc
h1 = findobj('Tag','cell_mat');
h2 = findobj('Tag','pro1_mat');
h3 = findobj('Tag','pro2_mat');
h4 = findobj('Tag','pro3_mat');
h5 = findobj('Tag','frame_no_cell');
h6 = findobj('Tag','start_frame');
h7 = findobj('Tag','end_frame');

h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');


outputFileName_cell = 'tmp_cell_stack.tif';
outputFileName_pro1 = 'tmp_pro1_stack.tif';
outputFileName_pro2 = 'tmp_pro2_stack.tif';
outputFileName_pro3 = 'tmp_pro3_stack.tif';

tmp_cell = get(h1,'UserData');
if val1 == 1
    tmp_pro1 = get(h2,'UserData');
end

if val2 == 1
    tmp_pro2 = get(h3,'UserData');
end

if val3 == 1
    tmp_pro3 = get(h4,'UserData');
end



h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));

for k = ki:ke
    
    axes(handles.dis_cell);
    imshow(tmp_cell(:,:,k));
    hold off
    if val1 == 1
        axes(handles.dis_pro1);
        imshow(tmp_pro1(:,:,k));
        hold off
    end
    
    if val2 == 1
        axes(handles.dis_pro2);
        imshow(tmp_pro2(:,:,k));
        hold off
    end
    
    if val3 == 1
        axes(handles.dis_pro3);
        imshow(tmp_pro3(:,:,k));
        hold off
    end   
    pause(0.003)
%     if k == ki
%         imwrite(tmp_cell(:, :, k), outputFileName_cell);
%         imwrite(tmp_pro1(:, :, k), outputFileName_pro1);
%         imwrite(tmp_pro2(:, :, k), outputFileName_pro2);
%         imwrite(tmp_pro3(:, :, k), outputFileName_pro3);
%     else
%         imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
%         imwrite(tmp_pro1(:, :, k), outputFileName_pro1, 'WriteMode', 'append');
%         imwrite(tmp_pro2(:, :, k), outputFileName_pro2, 'WriteMode', 'append');
%         imwrite(tmp_pro3(:, :, k), outputFileName_pro3, 'WriteMode', 'append');
%     end
    
end
hold off
% h1 = findobj('Tag','cell_mat');
% h2 = findobj('Tag','pro1_mat');
% h3 = findobj('Tag','pro2_mat');
% h4 = findobj('Tag','pro3_mat');
% 
% tmp_cell= get(h1,'UserData');
% tmp_pro1= get(h2,'UserData');
% tmp_pro2= get(h3,'UserData');
% tmp_pro3= get(h4,'UserData');
% 
% 
% for K=1:size(tmp_cell,3)
% set(h5, 'min', 1);

set(h5,'SliderStep',[1,0]);
mx = size(tmp_cell,3)
set(h5, 'max', mx);
set(h5, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h6, 'min', 1);
mx = size(tmp_cell,3);
set(h6,'SliderStep',[1,0]);
set(h6, 'max', mx);
set(h6, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h7, 'min', 1);
mx = size(tmp_cell,3)
set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', mx);    
%     
% end



% --- Executes on button press in Playall.
function Playall_Callback(hObject, eventdata, handles)
% hObject    handle to Playall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc
h1 = findobj('Tag','cell_channel');
h2 = findobj('Tag','pro1_channel');
h3 = findobj('Tag','pro2_channel');
h4 = findobj('Tag','pro3_channel');

h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');

tmp_cell = get(h1,'UserData');
if val1 == 1
    tmp_pro1= get(h2,'UserData');
end

if val2 == 1
    tmp_pro2= get(h3,'UserData');
end

if val3 == 1
    tmp_pro3= get(h4,'UserData');
end

h1 = findobj('Tag','cell_mat');
if val1 == 1
    h2 = findobj('Tag','pro1_mat');
end

if val2 == 1
    h3 = findobj('Tag','pro2_mat');
end

if val3 == 1
    h4 = findobj('Tag','pro3_mat');
end
h5 = findobj('Tag','frame_no_cell');
h6 = findobj('Tag','start_frame');
h7 = findobj('Tag','end_frame');
set(h1,'UserData',tmp_cell);
if val1 == 1
    set(h2,'UserData',tmp_pro1);
end

if val2 == 1
    set(h3,'UserData',tmp_pro2);
end

if val3 == 1
    set(h4,'UserData',tmp_pro3);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h5, 'min', 1);
mx = size(tmp_cell,3);
set(h5,'SliderStep',[1,0]);
set(h5, 'max', mx);
set(h5, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h6, 'min', 1);
mx = size(tmp_cell,3);
set(h6,'SliderStep',[1,0]);
set(h6, 'max', mx);
set(h6, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h7, 'min', 1);
mx = size(tmp_cell,3);
set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', mx);

% for k = 1:size(tmp_cell,3)
%     hold off
%     axes(handles.dis_cell);
%     imshow(tmp_cell(:,:,k));
%     axes(handles.dis_pro1);
%     imshow(tmp_pro1(:,:,k));
%     axes(handles.dis_pro2);
%     imshow(tmp_pro2(:,:,k));
%     axes(handles.dis_pro3);
%     imshow(tmp_pro3(:,:,k));
%     pause(0.003)
%     hold on
%     
% end
%  hold off


% --- Executes on button press in cell_mat.
function cell_mat_Callback(hObject, eventdata, handles)
% hObject    handle to cell_mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
tmp_cell= get(hObject,'UserData');
axes(handles.dis_cell);
% playframes1( mat, 0.003 )
h1 = findobj('Tag','frame_no_cell');
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));

outputFileName_cell = 'tmp_cell_stack.tif';

for k = 1:size(tmp_cell,3)
    hold off;
    if k>=ki && k<= ke
        imshow(tmp_cell(:,:,k));
        pause(0.003)
        hold on;
        set(h1,'value',k)
    end
    if k == 1
        imwrite(tmp_cell(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
    end
    
end
 set(h1,'value',ki) 


% --- Executes on button press in pro1_mat.
function pro1_mat_Callback(hObject, eventdata, handles)
% hObject    handle to pro1_mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
tmp_pro1= get(hObject,'UserData');
axes(handles.dis_pro1);
% playframes1( mat, 0.003 )
h1 = findobj('Tag','frame_no_cell');
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));
outputFileName_cell = 'tmp_pro1_stack.tif';

h1 = findobj('Tag','frame_no_cell');
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));

for k = 1:size(tmp_pro1,3)
    hold off;
    if k>=ki && k<= ke
        imshow(tmp_pro1(:,:,k));
        pause(0.003)
        hold on;
        set(h1,'value',k)
    end
    if k == 1
        imwrite(tmp_pro1(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_pro1(:, :, k), outputFileName_cell, 'WriteMode', 'append');
    end
    
end
 set(h1,'value',ki) 

% --- Executes on button press in pro2_mat.
function pro2_mat_Callback(hObject, eventdata, handles)
% hObject    handle to pro2_mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
tmp_pro2= get(hObject,'UserData');
axes(handles.dis_pro2);
% playframes1( mat, 0.003 )
h1 = findobj('Tag','frame_no_cell');
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));
outputFileName_cell = 'tmp_pro2_stack.tif';

for k = 1:size(tmp_pro2,3)
    hold off;
    if k>=ki && k<= ke
        imshow(tmp_pro2(:,:,k));
        pause(0.003)
        hold on;
        set(h1,'value',k)
    end
    if k == 1
        imwrite(tmp_pro2(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_pro2(:, :, k), outputFileName_cell, 'WriteMode', 'append');
    end
    
end
 set(h1,'value',ki) 



% --- Executes on button press in pro3_mat.
function pro3_mat_Callback(hObject, eventdata, handles)
% hObject    handle to pro3_mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
tmp_pro3= get(hObject,'UserData');
axes(handles.dis_pro3);
% playframes1( mat, 0.003 )
h1 = findobj('Tag','frame_no_cell');
% ki= round(get(h1,'value'));

h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));
outputFileName_cell = 'tmp_pro3_stack.tif';

for k = 1:size(tmp_pro3,3)
    hold off;
    if k>=ki && k<= ke
        imshow(tmp_pro3(:,:,k));
        pause(0.003)
        hold on;
        set(h1,'value',k)
    end
    if k == 1
        imwrite(tmp_pro3(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_pro3(:, :, k), outputFileName_cell, 'WriteMode', 'append');
    end
    
end
 set(h1,'value',ki) 




% --- Executes on button press in pro3_contra.
function pro3_contra_Callback(hObject, eventdata, handles)
% hObject    handle to pro3_contra (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h1 = findobj('Tag','pro3_mat');
h2 = findobj('Tag','contraLowPro3');
h3 = findobj('Tag','contraHighPro3');
low = get(h2,'Value');
high = get(h3,'Value');

mat = get(h1,'UserData');
%mat(400,400,1)
for i = 1:size(mat,3)
    img = mat(:,:,i);
    mat(:,:,i) = imadjust(img, [low high],[]);
end
%mat(400,400,1)
set(h1,'UserData',mat) 


% --- Executes on button press in pro2_contra.
function pro2_contra_Callback(hObject, eventdata, handles)
% hObject    handle to pro2_contra (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h1 = findobj('Tag','pro2_mat');
h2 = findobj('Tag','contraLowPro2');
h3 = findobj('Tag','contraHighPro2');
low = get(h2,'Value');
high = get(h3,'Value');

mat = get(h1,'UserData');
%mat(400,400,1)
for i = 1:size(mat,3)
    img = mat(:,:,i);
    mat(:,:,i) = imadjust(img, [low high],[]);
end
%mat(400,400,1)
set(h1,'UserData',mat) 


% --- Executes on button press in pro1_contra.
function pro1_contra_Callback(hObject, eventdata, handles)
% hObject    handle to pro1_contra (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h1 = findobj('Tag','pro1_mat');
h2 = findobj('Tag','contraLowPro1');
h3 = findobj('Tag','contraHighPro1');
low = get(h2,'Value');
high = get(h3,'Value');

mat = get(h1,'UserData');
%mat(400,400,1)
for i = 1:size(mat,3)
    img = mat(:,:,i);
    mat(:,:,i) = imadjust(img, [low high],[]);
end
%mat(400,400,1)
set(h1,'UserData',mat) 


% --- Executes on button press in cell_contra.
function cell_contra_Callback(hObject, eventdata, handles)
% hObject    handle to cell_contra (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
h1 = findobj('Tag','cell_mat');
h2 = findobj('Tag','contraLowCell');
h3 = findobj('Tag','contraHighCell');
low = get(h2,'Value');
high = get(h3,'Value');

mat = get(h1,'UserData');
%mat(400,400,1)
for i = 1:size(mat,3)
    img = mat(:,:,i);
    mat(:,:,i) = imadjust(img, [low high],[]);
end
%mat(400,400,1)
set(h1,'UserData',mat) 


% --- Executes on button press in mask.
function mask_Callback(hObject, eventdata, handles)

clc
h1 = findobj('Tag','cell_mat');
h2 = findobj('Tag','pro1_mat');
h3 = findobj('Tag','pro2_mat');
h4 = findobj('Tag','pro3_mat');
h5 = findobj('Tag','frame_no_cell');
h6 = findobj('Tag','start_frame');
h7 = findobj('Tag','end_frame');
h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');
% h11 = findobj('Tag','Pxsz');
% data =  round(str2double(get(h11,'String')));
% fileID=fopen('tmp.txt','w');
% fprintf(fileID,'%d\n',data);
% fclose(fileID);


outputFileName_cell = 'tmp_cell_stack.tif';
outputFileName_pro1 = 'tmp_pro1_stack.tif';
outputFileName_pro2 = 'tmp_pro2_stack.tif';
outputFileName_pro3 = 'tmp_pro3_stack.tif';


tmp_cell = get(h1,'UserData');


if val1 == 1
    tmp_pro1 = get(h2,'UserData');
end

if val2 == 1
    tmp_pro2 = get(h3,'UserData');
end

if val3 == 1
    tmp_pro3 = get(h4,'UserData');
end


h2 = findobj('Tag','start_frame');
ki= round(get(h2,'value'));

h3 = findobj('Tag','end_frame');
ke= round(get(h3,'value'));

for k = ki:ke
    

    if k == ki
        
        imwrite(tmp_cell(:, :, k), outputFileName_cell);
        if val1 == 1
            imwrite(tmp_pro1(:, :, k), outputFileName_pro1);
        end
        if val2 == 1
            imwrite(tmp_pro2(:, :, k), outputFileName_pro2);
        end
        if val3 == 1
            imwrite(tmp_pro3(:, :, k), outputFileName_pro3);
        end
    else
        
        imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
        if val1 == 1
            imwrite(tmp_pro1(:, :, k), outputFileName_pro1, 'WriteMode', 'append');
        end
        if val2 == 1
            imwrite(tmp_pro2(:, :, k), outputFileName_pro2, 'WriteMode', 'append');
        end
        
        if val3 == 1 
            imwrite(tmp_pro3(:, :, k), outputFileName_pro3, 'WriteMode', 'append');
        end
    end
    
end
% hold off
% h1 = findobj('Tag','cell_mat');
% h2 = findobj('Tag','pro1_mat');
% h3 = findobj('Tag','pro2_mat');
% h4 = findobj('Tag','pro3_mat');
% 
% tmp_cell= get(h1,'UserData');
% tmp_pro1= get(h2,'UserData');
% tmp_pro2= get(h3,'UserData');
% tmp_pro3= get(h4,'UserData');
% 
% 
% for K=1:size(tmp_cell,3)
% set(h5, 'min', 1);

set(h5,'SliderStep',[1,0]);
mx = size(tmp_cell,3)
set(h5, 'max', mx);
set(h5, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h6, 'min', 1);
mx = size(tmp_cell,3);
set(h6,'SliderStep',[1,0]);
set(h6, 'max', mx);
set(h6, 'value', 1); % Somewhere between max and min.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h7, 'min', 1);
mx = size(tmp_cell,3)
set(h7,'SliderStep',[1,0]);
set(h7, 'max', mx);
set(h7, 'value', mx);    
%     
% end
maskAnalysis


% --- Executes on button press in rotate.
function rotate_Callback(hObject, eventdata, handles)
% hObject    handle to rotate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc
h1 = findobj('Tag','cell_mat');
h2 = findobj('Tag','pro1_mat');
h3 = findobj('Tag','pro2_mat');
h4 = findobj('Tag','pro3_mat');
h5 = findobj('Tag','frame_no_cell');

tmp_cell = get(h1,'UserData');
tmp_pro1 = get(h2,'UserData');
tmp_pro2 = get(h3,'UserData');
tmp_pro3 = get(h4,'UserData');

h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');

ki = round(get(h5,'value'));


axes(handles.dis_cell)
imshow(tmp_cell(:,:,ki))
hold on

[x(1) y(1)] = ginput(1);
% xL = xlim;
% yL = ylim
line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis

[x(2) y(2)] = ginput(1);
line([x(1) x(2)],[y(1) y(2)],'color','y');


line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis

[x(3) y(3)] = ginput(1);
line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
line([x(1) x(3)],[y(1) y(3)],'color','b');
rot_cell = rotate_frames(tmp_cell,x,y);
set(h1,'UserData',rot_cell );
hold on
imshow(rot_cell(:,:,ki));
line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis
line([x(1) x(2)],[y(1) y(2)],'color','y');
line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis
line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
line([x(1) x(3)],[y(1) y(3)],'color','b');

hold off


if val1 == 1
    axes(handles.dis_pro1)
    imshow(tmp_pro1(:,:,ki))
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis

    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis

    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    rot_pro1 = rotate_frames(tmp_pro1,x,y);
    set(h2,'UserData',rot_pro1 );
    hold on
    imshow(rot_pro1(:,:,ki));
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis
    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis
    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    hold off
end


if val2 == 1
    axes(handles.dis_pro2)
    imshow(tmp_pro2(:,:,ki))
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis

    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis

    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    rot_pro2 = rotate_frames(tmp_pro2,x,y);
    set(h3,'UserData',rot_pro2 );
    hold on
    imshow(rot_pro2(:,:,ki));
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis
    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis
    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    hold off
end


if val3== 1
    axes(handles.dis_pro3)
    imshow(tmp_pro3(:,:,ki))
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis

    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis

    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    rot_pro3 = rotate_frames(tmp_pro3,x,y);
    set(h4,'UserData',rot_pro3 );
    hold on
    imshow(rot_pro3(:,:,ki));
    line([x(1)-size(tmp_cell, 1)*2 x(1)+size(tmp_cell, 1)*2], [ y(1) y(1)],'color','r');  %x-axis
    line([x(1) x(1)], [y(1)-size(tmp_cell, 2)*2 y(1)+size(tmp_cell, 2)*2],'color','r');  %x-axis
    line([x(1) x(2)],[y(1) y(2)],'color','y');
    line([x(2)-5 x(2)+5], [ y(2) y(2)],'color','y');  %x-axis
    line([x(2) x(2)], [y(2)-5 y(2)+5],'color','y');  %x-axis
    line([x(3)-5 x(3)+5], [ y(3) y(3)],'color','g');  %x-axis
    line([x(3) x(3)], [y(3)-5 y(3)+5],'color','g');  %x-axis
    line([x(1) x(3)],[y(1) y(3)],'color','b');

    hold off
end

outputFileName_cell = 'tmp_cell_stack.tif';
outputFileName_pro1 = 'tmp_pro1_stack.tif';
outputFileName_pro2 = 'tmp_pro2_stack.tif';
outputFileName_pro3 = 'tmp_pro3_stack.tif';

for k = 1:size(tmp_cell,3)
    
%     axes(handles.dis_cell);
%     imshow(tmp_cell(:,:,k));
%     hold off
%     axes(handles.dis_pro1);
%     imshow(tmp_pro1(:,:,k));
%     hold off
%     axes(handles.dis_pro2);
%     imshow(tmp_pro2(:,:,k));
%     hold off
%     axes(handles.dis_pro3);
%     imshow(tmp_pro3(:,:,k));
%     hold off
%     pause(0.003)
    if k == 1
        
        imwrite(rot_cell(:, :, k), outputFileName_cell);
        if val1 == 1
            imwrite(rot_pro1(:, :, k), outputFileName_pro1);
        end
        if val2 == 1
            imwrite(rot_pro2(:, :, k), outputFileName_pro2);
        end
        if val3 == 1
            imwrite(rot_pro3(:, :, k), outputFileName_pro3);
        end
    else
        
        imwrite(rot_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
        if val1 == 1
            imwrite(rot_pro1(:, :, k), outputFileName_pro1, 'WriteMode', 'append');
        end
        if val2 == 1
            imwrite(rot_pro2(:, :, k), outputFileName_pro2, 'WriteMode', 'append');
        end
        
        if val3 == 1 
            imwrite(rot_pro3(:, :, k), outputFileName_pro3, 'WriteMode', 'append');
        end
    end
    
end









% --- Executes on slider movement.
function frame_no_cell_Callback(hObject, eventdata, handles)
% hObject    handle to frame_no_cell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');

h1 =findobj('Tag','cell_mat');
tmp_cell = get(h1,'UserData');
k = get(hObject,'Value')
k = round(k)

axes(handles.dis_cell);
imshow(tmp_cell(:,:,k));
hold off
if val1 == 1
    h2 =findobj('Tag','pro1_mat');
    tmp_pro1 = get(h2,'UserData');
    axes(handles.dis_pro1);
    imshow(tmp_pro1(:,:,k));
    hold off
end

if val2 == 1
    h3 =findobj('Tag','pro2_mat');
    tmp_pro2 = get(h3,'UserData');
    axes(handles.dis_pro2);
    imshow(tmp_pro2(:,:,k));
    hold off
end

if val3 == 1
    h4 =findobj('Tag','pro3_mat');
    tmp_pro3 = get(h4,'UserData');
    axes(handles.dis_pro3);
    imshow(tmp_pro3(:,:,k));
    hold off

end









% --- Executes during object creation, after setting all properties.
function frame_no_cell_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frame_no_cell (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in del_reg.
function del_reg_Callback(hObject, eventdata, handles)
% hObject    handle to del_reg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc
h1 =findobj('Tag','cell_mat');
h2 =findobj('Tag','pro1_mat');
h3 =findobj('Tag','pro2_mat');
h4 =findobj('Tag','pro3_mat');

h8 = findobj('Tag','conf_pro1');
val1 = get(h8,'value');

h9 = findobj('Tag','conf_pro2');
val2 = get(h9,'value');

h10 = findobj('Tag','conf_pro3');
val3 = get(h10,'value');

tmp_cell= get(h1,'UserData');
% if val1 == 1
%     tmp_pro1= get(h2,'UserData');
% end
% 
% if val2 == 1
%     tmp_pro2= get(h3,'UserData');
% end
% 
% if val3 == 1
%     tmp_pro3= get(h4,'UserData');
% end

axes(handles.dis_cell);
h5 =findobj('Tag','frame_no_cell');
k = round(get(h5,'value'))
BW = roipoly(tmp_cell(:,:,k));
tmp_cell = delete_region(tmp_cell,BW);
% playframes1( mat, 0.003 )
set(h1,'UserData',tmp_cell);
outputFileName_cell = 'tmp_cell_stack.tif';


for k = 1:size(tmp_cell,3)
    
%     axes(handles.dis_cell);
%     imshow(tmp_cell(:,:,k));
%     hold off
%     axes(handles.dis_pro1);
%     imshow(tmp_pro1(:,:,k));
%     hold off
%     axes(handles.dis_pro2);
%     imshow(tmp_pro2(:,:,k));
%     hold off
%     axes(handles.dis_pro3);
%     imshow(tmp_pro3(:,:,k));
%     hold off
%     pause(0.003)
    if k == 1
        imwrite(tmp_cell(:, :, k), outputFileName_cell);
        
    else
        imwrite(tmp_cell(:, :, k), outputFileName_cell, 'WriteMode', 'append');
        
    end
    
end



function Pxsz_Callback(hObject, eventdata, handles)
% hObject    handle to Pxsz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Pxsz as text
%        str2double(get(hObject,'String')) returns contents of Pxsz as a double
% data =  round(str2double(get(hObject,'String')));
% fileID=fopen('tmp.txt','w');
% fprintf(fileID,'%d\n',data);
data =  round(str2double(get(hObject,'String')));
fileID=fopen('tmp.txt','w');
fprintf(fileID,'%d\n',data);
fclose(fileID);


% --- Executes during object creation, after setting all properties.
function Pxsz_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Pxsz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit8_Callback(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit8 as text
%        str2double(get(hObject,'String')) returns contents of edit8 as a double


% --- Executes during object creation, after setting all properties.
function edit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton19.
function pushbutton19_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in crp_frm.
function crp_frm_Callback(hObject, eventdata, handles)
% hObject    handle to crp_frm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of crp_frm


% --- Executes on slider movement.
function start_frame_Callback(hObject, eventdata, handles)
% hObject    handle to start_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function start_frame_CreateFcn(hObject, eventdata, handles)
% hObject    handle to start_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function end_frame_Callback(hObject, eventdata, handles)
% hObject    handle to end_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function end_frame_CreateFcn(hObject, eventdata, handles)
% hObject    handle to end_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in conf_pro1.
function conf_pro1_Callback(hObject, eventdata, handles)
% hObject    handle to conf_pro1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of conf_pro1


% --- Executes on button press in conf_pro2.
function conf_pro2_Callback(hObject, eventdata, handles)
% hObject    handle to conf_pro2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of conf_pro2


% --- Executes on button press in conf_pro3.
function conf_pro3_Callback(hObject, eventdata, handles)
% hObject    handle to conf_pro3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of conf_pro3


% --- Executes on button press in msk_frm_chan.
function msk_frm_chan_Callback(hObject, eventdata, handles)
% hObject    handle to msk_frm_chan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of msk_frm_chan
