function [corx , cory] = divide_line(no_divs,cor_start,cor_end,thresh)
%% no_div (>=1)is the number of segments, cor_start is the start cordinates of the
%line, cor_end is the is tthe end coordinates of the line,thresh is the
%length above which the division will start
xo = cor_start(1);
x0 = cor_end(1);
yo = cor_start(2);
y0 = cor_end(2);


distance = sqrt((x0-xo)^2+(y0-yo)^2);
corx(1)= xo;
corx(no_divs+1)=x0;
cory(1)  = yo ;
cory(no_divs+1) = y0;
if distance>=thresh
    for i = 1:no_divs
        corx(i+1)= xo + (i)/no_divs*(x0-xo);
        cory(i+1)= yo + (i)/no_divs*(y0-yo);
    end
end
end
    

