angle=1;


// Load Micropattern Images
title = "PART 1: SELECT MICRO-PATTERN";
msg = "Please Select Micropattern (Brightfield)";
waitForUser(title, msg);
open();
name=getTitle()
rename("IF-micro_raw.tif");

title = "PART 1: SELECT MICRO-PATTERN";
msg = "Please Select Micropattern (SEM)";
waitForUser(title, msg);
open();
name=getTitle()
rename("SEM-micro.tif");

// Load CLEM images
title = "PART 2: SELECT CLEM IMAGES";
msg = "Please Select Fluorescence Image";
waitForUser(title, msg);
open();
name=getTitle()
rename("IF_raw.tif");

title = "PART 2: SELECT CLEM IMAGES";
msg = "Please Select SEM Image";
waitForUser(title, msg);
open();
name=getTitle()
rename("SEM.tif");


// Rescale BOTH Light-Microscopy Images
Dialog.create("Enter alignment parameters"); 
Dialog.addNumber("Pixel size of Fluorescence image (in nm):", 100); 
Dialog.addNumber("Pixel size of of SEM image (in nm):", 100); 
Dialog.show(); 

fl = Dialog.getNumber(); // pixel size Light Microscopy
sl = Dialog.getNumber(); // pixel size SEM
ratio = fl/sl; // scaling factor for Light Microscopy Images


selectWindow("IF-micro_raw.tif");
run("Scale...", "x="+ratio+" y="+ratio+" interpolation=Bilinear average create title=IF-micro.tif");
selectWindow("IF-micro_raw.tif");
close();

selectWindow("IF_raw.tif");
run("Scale...", "x="+ratio+" y="+ratio+" interpolation=Bilinear average create title=IF.tif");
selectWindow("IF_raw.tif");
close();


// Get rotation parameter (i.e. angle) from Micro-pattern
dir = getDirectory("Choose where to put stuff");

Dialog.create("Enter rotational step size"); 
Dialog.addNumber("Enter step size (in degree):", 100); 
Dialog.show(); 


a = Dialog.getNumber(); // step size
n = 360/a; // total steps

i = 0; 
l = 0;

selectWindow("IF-micro.tif");
rename("rotate-1.tif");

   do {
      selectWindow("SEM-micro.tif");
      rename("rotate-2.tif");
      run("Rotate... ", "angle=i grid=1 interpolation=Bilinear fill enlarge");
      	run("Subtract...", "value=200");
	run("Multiply...", "value=20");
      run("Pairwise stitching", "first_image=rotate-2.tif second_image=rotate-1.tif fusion_method=[Linear Blending] check_peaks=5 compute_overlap subpixel_accuracy x=1518.9608 y=-2019.1666 registration_channel_image_1=[Average all channels] registration_channel_image_2=[Average all channels]");
      rename("delete");
      run("RGB Color");
      rename("image-" + i);
       		 t=getTitle();
       		 saveAs("Tiff", dir + t + ".tif");
       		 close();
      selectWindow("delete");
      close();
      selectWindow("rotate-2.tif");
      close();
      i = i + a;
      l = l + 1;
   } while (i<=360);

selectWindow("rotate-1.tif");
close();

run("Image Sequence...", "open=C:\\Users\\GALIC\\Desktop\\bastel number=n starting=0 increment=1 scale=100 file=image- sort");
run("Split Channels");
	selectWindow("bastel (blue)");
	close();
	selectWindow("bastel (green)");
	run("16-bit");
	selectWindow("bastel (red)");
	run("16-bit");
	imageCalculator("Multiply create stack", "bastel (red)","bastel (green)");
selectWindow("Result of bastel (red)");

makeRectangle(0, 0, 5555, 5555);
run("Add to Manager");
roiManager("Add");
roiManager("Select", 0);


// Get translation parameter (i.e. X and Y) from Micro-pattern

selectWindow("SEM-micro.tif");
run("Rotate... ", "angle="+angle+" grid=1 interpolation=Bilinear enlarge"); 


print(a,b,ratio,angle,X,Y); 

// align Micro-pattern




// rotate SEM image (parameter: angle)

selectWindow("SEM.tif");
run("Rotate... ", "angle="+angle+" grid=1 interpolation=Bilinear enlarge"); 


// align images (parameter: x and y)

newImage("background", "8-bit white", 5000, 5000, 1);
run("Images to Stack", "method=[Copy (top-left)] name=Stack title=[] use");
run("Stack to Images");
selectWindow("background");
close();
selectWindow("SEM");
run("Translate...", "x=X y=Y interpolation=None"); 
run("Images to Stack", "name=Overlay title=[] use");
